<?php
/**
 * Plugin Name: Hide Already Up-to-Date Plugin Notices
 * Description: Nasconde le notifiche di aggiornamento quando la versione installata è uguale o superiore a quella proposta, per tutti i plugin.
 * Version: 1.2
 * Author: Davide and ChatGPT
 */

if ( ! defined('ABSPATH') ) exit;

/**
 * Normalize version strings (strip spaces, build suffixes etc.)
 */
function dm_normalize_version( $v ) {
    $v = trim( (string) $v );
    // Keep digits and dots only (drop things like '-build', '+meta', ' (pro)')
    $v = preg_replace('/[^0-9.]/', '', $v);
    return $v ?: '0';
}

function dm_hide_equal_plugin_updates( $value ) {
    if ( empty($value) || ! is_object($value) ) return $value;

    // Core structure guards
    if ( empty($value->response) || ! is_array($value->response) ) return $value;

    // Load installed plugin data once
    if ( ! function_exists('get_plugins') ) {
        require_once ABSPATH . 'wp-admin/includes/plugin.php';
    }
    $installed = get_plugins();

    foreach ( $value->response as $plugin_file => $update_obj ) {
        if ( empty($installed[$plugin_file]) ) continue;

        $installed_version = dm_normalize_version( $installed[$plugin_file]['Version'] ?? '' );
        $new_version       = dm_normalize_version( $update_obj->new_version ?? '' );

        if ( $installed_version && $new_version ) {
            // If installed >= proposed, hide it
            if ( version_compare( $installed_version, $new_version, '>=' ) ) {
                // Mark as no_update to be extra explicit
                if ( ! isset($value->no_update) || ! is_array($value->no_update) ) {
                    $value->no_update = [];
                }
                $value->no_update[$plugin_file] = $update_obj;

                // Remove from response so the UI doesn't show the nag
                unset( $value->response[$plugin_file] );

                // Also ensure 'checked' reflects what we have installed
                if ( isset($value->checked) && is_array($value->checked) ) {
                    $value->checked[$plugin_file] = $installed[$plugin_file]['Version'];
                }
            }
        }
    }

    return $value;
}

// Run both before and after the transient is set, with high priority
add_filter( 'pre_set_site_transient_update_plugins', 'dm_hide_equal_plugin_updates', 9999 );
add_filter( 'site_transient_update_plugins',        'dm_hide_equal_plugin_updates', 9999 );
